package com.ejie.aa17a.dao.impl;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.sql.DataSource;

import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.aa17a.dao.iface.Aa17aAvisoDao;
import com.ejie.aa17a.model.Aa17aAviso;
import com.ejie.aa17a.utilidades.Aa17aConstantes;

/**
 * Aa17aAvisoDaoImpl generated by UDA, 18-dic-2013 15:36:14.
 * 
 * @author UDA
 */

@Transactional
public class Aa17aAvisoDaoImpl implements Aa17aAvisoDao {
	private JdbcTemplate jdbcTemplate;
	private RowMapper<Aa17aAviso> rwMap = new RowMapper<Aa17aAviso>() {
		public Aa17aAviso mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			return new Aa17aAviso(
					resultSet.getLong("IDAVISO"), resultSet.getLong("IDESTACION"), resultSet.getString("TEXTOAVISO")
			);
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */

	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/**
	 * Finds a List of rows in the Aa17aAviso table.
	 * 
	 * @param aa17aaviso
	 *            Aa17aAviso
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Aa17aAviso> findAll(Aa17aAviso aa17aaviso) {
		StringBuilder query = new StringBuilder("SELECT t1.T06_AVISO_ID IDAVISO,t1.T01_ESTACION_ID IDESTACION,t1.T06_TEXTO_AVISO TEXTOAVISO ");
		query.append("FROM AA1706S00 t1 ");

		//Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(aa17aaviso);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return (List<Aa17aAviso>) this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());
	}

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Aa17aAviso entity
	 * 
	 * @param aa17aaviso
	 *            Aa17aAviso Bean with the criteria values to filter by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(Aa17aAviso aa17aaviso) {

		StringBuffer where = new StringBuffer(Aa17aAvisoDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (aa17aaviso != null && aa17aaviso.getIdAviso() != null) {
			where.append(" AND t1.T06_AVISO_ID = ?");
			params.add(aa17aaviso.getIdAviso());
		}
		//si buscamos por idEstacion
		if (aa17aaviso != null && aa17aaviso.getIdEstacion() != null) {
			where.append(" AND t1.T01_ESTACION_ID = ?");
			params.add(aa17aaviso.getIdEstacion());
		}
		else {
			//si el idEstacion es nulo, devuelvo todos los avisos generales
			where.append(" AND t1.T01_ESTACION_ID IS NULL ");
		}

		if (aa17aaviso != null && aa17aaviso.getEstado() != null) {
			if (aa17aaviso.getEstado().equals(Aa17aConstantes.ESTADO_ACTIVO)) {
				where.append(" AND t1.T06_FECHA_BAJA IS NULL ");
			}
			else {
				where.append(" AND NOT t1.T06_FECHA_BAJA IS NULL ");
			}
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;
}
